#include <iostream>
#include <vector>
#include <list>

using std::cout;
using std::cin;
using std::endl;


/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}


/* umesto da pisemo zasebne funkcije za:
 inkrementaciju svih elemenata kolekcije, dekrementaciju, kvadriranje...
 mozemo da napisemo jednu funkciju viseg reda
 koja prosledjenu unarnu transformaciju primenjuje
 nad svim elementima kolekcije proizvoljnog tipa 
 
 f je pokazivac na funkciju koja kao argument prima referencu na objekat tipa T 
 ( s obzirom da T moze da bude i klasni tip ) i preko te reference ga menja 
 */
template <typename Kol, typename T>
void transformisi(Kol &k, void (*f)(T&)){
	/* prolazimo kroz kolekciju */	
	for(typename Kol::iterator it = k.begin(); it!=k.end(); it++){
		/* na element kolekcije primenjujemo funkciju f */
		f(*it);
	}
}

/* definisemo inkrementaciju */
template <typename T>
void ink(T& x){
	x = x+1; 
}
/* definisemo dekrementaciju */
template <typename T>
void dek(T& x){
	x = x-1; 
}
/* definisemo kvadriranje */
template <typename T>
void kvad(T& x){
	x = x*x; 
}

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata niza:"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite niz celih brojeva:"<<endl;
	ucitaj< std::vector<int>,int>(v1,n);
	cout<<"Uneli ste niz:"<<endl;
	ispis(v1);
	cout<<"Niz nakon inkrementacije svih elemenata:"<<endl;
	transformisi(v1, ink<int>);
	ispis(v1);
	cout<<"Niz nakon dekrementacije svih elemenata:"<<endl;
	transformisi(v1, dek<int>);
	ispis(v1);
	cout<<"Niz nakon kvadriranja svih elemenata:"<<endl;
	transformisi(v1, kvad<int>);
	ispis(v1);
	
	cout<<"Unesite broj elemenata liste:"<<endl;
	cin >> n;
	std::list<double> l1;
	cout<<"Unesite listu realnih brojeva:"<<endl;
	ucitaj< std::list<double>, double>(l1,n);
	cout<<"Uneli ste listu:"<<endl;
	ispis(l1);
	cout<<"Lista nakon inkrementacije svih elemenata:"<<endl;
	transformisi(l1, ink<double>);
	ispis(l1);
	cout<<"Lista nakon dekrementacije svih elemenata:"<<endl;
	transformisi(l1, dek<double>);
	ispis(l1);
	cout<<"Lista nakon kvadriranja svih elemenata:"<<endl;
	transformisi(l1, kvad<double>);
	ispis(l1);
}
