#include <iostream>
#include <vector>
#include <functional>

using std::cout;
using std::cin;
using std::endl;

/* sablon za ispis proizvoljne kolekcije */
template <typename Kol>
void ispis(const Kol &k){
	for(typename Kol::const_iterator it=k.begin(); it!=k.end(); it++){
		cout<< *it << " ";
	}
	std::cout << std::endl;
}

/* sablon za ucitavanje proizvoljne kolekcije, kolekcija tipa Kol kao elemente ima objekte tipa T */
template <typename Kol, typename T>
void ucitaj(Kol &k, int n){
	T x;
	for(int i=0; i<n; i++){
		cin>>x;
		k.push_back(x);
	}
}

/*
Funkcija sumaIzabranih vraća sumu izabranih elemenata vektora. Ova funkcija ne zna
kriterijum po kojem se biraju elementi za sumiranje već se kriterijum određuje nekom 
drugom funkcijom koja se predaje kao dodatni parametar (function<bool(int)>kriterijum).
Obično u slučajevima kada funkciju predajemo drugoj funkciji koristimo pokazivače na
funkcije kao u prethodnim primerima, medjutim izraz function (zaglavlje functional) omogućava 
nam da predamo običnu funkciju, funkcijski objekat pa čak i lambda funkciju kao parametar drugoj funkciji. 
U nasem primeru funkcija koja se predaje ima povratnu vrijednost bool i ulazni parametar tipa int.
*/
int sumaIzabranih(const std::vector<int> &v, std::function<bool(int)> kriterijum){
    int s = 0;
    for (int i = 0; i < v.size(); i++) {
        if(kriterijum(v[i])) // ukoliko v[i] zadovoljava kriterijum
            s += v[i];
    }
    return s;
}

// unarna funkcija koja proverava da li je element vektora paran
bool jeParan(int n){
    return !(n%2);
}

// Funkcijski objekat klase Paran unutar svog operatora ( ) vraća
// informaciju da li je neki broj paran ili ne
class Paran{
    public:
        bool operator()(int n){
            return !(n%2);
        }
};

int main(){
	unsigned n;
	cout<<"Unesite broj elemenata vektora:"<<endl;
	cin >> n;
	std::vector<int> v1;
	cout<<"Unesite vektor celih brojeva:"<<endl;
	ucitaj< std::vector<int>, int>(v1,n);
	cout<<"Uneli ste vektor:"<<endl;
	ispis(v1);
    cout << "Suma parnih elemenata vektora (argument je funkcija jeParan): " << sumaIzabranih(v1, jeParan) << endl;
    cout << "Suma parnih elemenata vektora (argument je funkcijski objekat klase Paran): " << sumaIzabranih(v1, Paran()) << endl;
    cout << "Suma parnih elemenata vektora (argument je lambda funkcija): " << sumaIzabranih(v1, [](int n){return !(n%2);}) << endl;
    
}
