#include <iostream>
#include <map>
#include <vector>
#include <algorithm>

using namespace std;

// funkcija koja se prosledjuje kao kriterijum za sortiranje vektora parova opadajuce
// posto poredimo po broju pojavljivanja, poredimo second elemente parova
bool poredi(const pair<string, int> &a,  const pair<string, int> &b){ 
    return (a.second > b.second); 
} 

int main(){
    // za prebrojavanje pojavljivanja imena cemo koristiti mapu 
    // kljucevi - imena, vrednosti - broj pojavljivanja 
	map<string, int> imena;
    int n;
    cout<<"Unesite broj imena:"<<endl;
	cin >> n;
	cout<<"Unesite imena"<<endl;
    for(int i=0;i<n;i++){
        string ime;
        cin >> ime;
        // ako ime ne postoji u mapi, dodajemo novi par i vrednost se postavlja na 1
		// ako ime postoji, tekuca vrednost se uvecava za 1 i azurira se mapa
        if(imena.find(ime) == imena.end())
			imena[ime] = 1;
		else 
			imena[ime] = imena[ime] + 1;
    }
	// trazimo par koji ima najvecu vrednost u mapi 
	// mapa je interno sortirana po kljucevima
	// prvi nacin je da sami pronadjemo trazeni par 
	// maxit je iterator na do tada pronadjen par sa najvecom vrednoscu
	// it je tekuci koji se poredi sa maxit
	map<string, int>::const_iterator it, maxit;
	for(it = imena.begin(); it!=imena.end(); it++){
		if(it == imena.begin())
			maxit = imena.begin();
		else if(it->second > maxit->second)
			maxit = it;
	} 
	cout << "Ime koje se najvise puta pojavilo: " << maxit->first << ", broj pojavljivanja: " << maxit->second << endl;

	// drugi nacin je sortiranje ucitanih podataka po vrednostima iz mape, a ne po kljucu kako je interno sortiranje za mapu
	// ako sortiramo opadajuce po vrednostima, prvi par nakon sortiranja ce sadrzati ime koje je najcesce
	// da bismo to sproveli, kopiracemo podatke iz mape u vektor parova i sortirati ih pomocu kriterijuma koji definisemo
	vector<pair<string, int>> imenaVektor;

	// kopiramo iz mape u vektor 
  	for (it=imena.begin(); it!=imena.end(); it++){
    	imenaVektor.push_back(make_pair(it->first, it->second));
	}

	// sortiramo vektor opadajuce pomocu funkcije koja poredi second elemente parova, tj. vrednosti
  	sort(imenaVektor.begin(), imenaVektor.end(), poredi); 

	// ispisujemo podatke, prvi je ujedno najcesce ime
	cout << "Ime koje se najvise puta pojavilo (drugo resenje): " << imenaVektor[0].first << ", broj pojavljivanja: " << imenaVektor[0].second << endl;
	cout << "Podaci nakon sortiranja: " << endl;
	for (int i = 0; i < imenaVektor.size(); i++){
		cout << "Ime: " << imenaVektor[i].first << ", broj pojavljivanja: " << imenaVektor[i].second << endl;
	}
}