#include<iostream>

// primeri za lambda funkciju koja racuna sumu dve celobrojne vrednosti
int main(){
    int a = 10, b = 2, suma;
    /*
        [](parametri)->povratni_tip{ telo funkcije }
        [] - klauzula hvatanja
        povratni tip nije obavezan ako se moze zakljuciti iz naredbi 
    */
    suma = [](int x, int y){return x+y;} (a,b);
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
    // u klauzuli hvatanja dodajemo lokalne promenljive funkcije pozivaoca (main)
    // za koje zelimo da budu dostupne u okviru tela lambda funkcije
    // a, b se prenose po vrednosti i sada nije potrebno da se prosledjuju kao argumenti
    suma = [a,b]()->int{return a+b;}();
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
    // znak = u klauzuli hvatanja znaci da se sve lokalne promenljive funkcije pozivaoca (main)
    // prenose po vrednosti
    suma = [=]()->int{return a+b;}();
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
    // ako zelimo da prenos bude po referenci koristimo znak & u klauzuli hvatanja 
    // sada svaka izmena a i b u okviru lambde utice na a i b iz main-a
    suma = [&]()->int{a++; b++; return a+b;}();
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
    // mozemo izabrati koje promenljive prenosimo po vrednosti, a koje po referenci
    // a se prenosi po vrednosti, b po referenci 
    suma = [a, &b]()->int{b++; return a+b;}();
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
    // sve se prenosi po referenci izuzev b koje se prenosi po vrednosti
    suma = [&, b]()->int{a++; return a+b;}();
    std::cout << "a: " << a << ", b: " << b << ", suma " << suma << std::endl;
    
}